(function(){
    const { __ } = wp.i18n;
    const { registerBlockType } = wp.blocks;
    const { PanelBody, TextControl, SelectControl, ToggleControl, RangeControl, ColorPalette } = wp.components;
    const { InspectorControls } = wp.blockEditor || wp.editor;
    const el = wp.element.createElement;

    const palette = ['#22d3ee','#6366f1','#0ea5e9','#0b1225','#111827','#f97316','#22c55e','#f8fafc'];

    const inlineBg = (type, from, to) => {
        if(type === 'solid') return { background: from };
        if(type === 'gradient') return { background: `linear-gradient(135deg, ${from}, ${to})` };
        return {};
    };

    registerBlockType('loginwa/otp-login', {
        title: __('LoginWA OTP Login','loginwa-otp'),
        icon: 'shield',
        category: 'widgets',
        attributes: {
            heading: { type:'string', default:'LoginWA OTP Login' },
            subheading: { type:'string', default:'' },
            description: { type:'string', default:'' },
            badge: { type:'string', default:'Passwordless access' },
            hint: { type:'string', default:'We will text a one-time code.' },
            accent_color: { type:'string', default:'#22d3ee' },
            background_type: { type:'string', default:'default' },
            background_from: { type:'string', default:'#22d3ee' },
            background_to: { type:'string', default:'#6366f1' },
            card_max_width: { type:'number', default:420 },
            border_radius: { type:'number', default:18 },
            shadow: { type:'boolean', default:true },
            layout: { type:'string', default:'split' },
            hero_align: { type:'string', default:'center' },
            show_hero: { type:'boolean', default:true },
            show_badge: { type:'boolean', default:true },
            show_hint: { type:'boolean', default:true },
            body_gap: { type:'number', default:28 },
            form_padding: { type:'number', default:22 },
            logo_url: { type:'string', default:'' },
            logo_alt: { type:'string', default:'LoginWA' },
            show_country: { type:'boolean', default:true },
            theme_mode: { type:'string', default:'auto' },
            send_label: { type:'string', default:'Send code' },
            verify_label: { type:'string', default:'Login' },
            phone_placeholder: { type:'string', default:'81234567890' },
            otp_placeholder: { type:'string', default:'123456' },
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const set = (key) => (value) => setAttributes({ [key]: value });

            return el('div', { className:'loginwa-otp-block-editor' }, [
                el(InspectorControls, {}, [
                    el(PanelBody, { title: __('Content', 'loginwa-otp'), initialOpen:true }, [
                        el(ToggleControl, { label: __('Show hero section','loginwa-otp'), checked: attributes.show_hero, onChange: set('show_hero') }),
                        el(ToggleControl, { label: __('Show badge','loginwa-otp'), checked: attributes.show_badge, onChange: set('show_badge') }),
                        el(TextControl, { label: __('Heading','loginwa-otp'), value: attributes.heading, onChange: set('heading') }),
                        el(TextControl, { label: __('Subheading','loginwa-otp'), value: attributes.subheading, onChange: set('subheading') }),
                        el(TextControl, { label: __('Description','loginwa-otp'), value: attributes.description, onChange: set('description') }),
                        el(TextControl, { label: __('Badge','loginwa-otp'), value: attributes.badge, onChange: set('badge') }),
                        el(TextControl, { label: __('Logo URL','loginwa-otp'), value: attributes.logo_url, onChange: set('logo_url') }),
                        el(TextControl, { label: __('Logo alt text','loginwa-otp'), value: attributes.logo_alt, onChange: set('logo_alt') }),
                    ]),
                    el(PanelBody, { title: __('Form & Labels','loginwa-otp'), initialOpen:false }, [
                        el(ToggleControl, { label: __('Show country dropdown','loginwa-otp'), checked: attributes.show_country, onChange: set('show_country') }),
                        el(ToggleControl, { label: __('Show hint','loginwa-otp'), checked: attributes.show_hint, onChange: set('show_hint') }),
                        el(TextControl, { label: __('Hint text','loginwa-otp'), value: attributes.hint, onChange: set('hint') }),
                        el(TextControl, { label: __('Send button label','loginwa-otp'), value: attributes.send_label, onChange: set('send_label') }),
                        el(TextControl, { label: __('Verify button label','loginwa-otp'), value: attributes.verify_label, onChange: set('verify_label') }),
                        el(TextControl, { label: __('Phone placeholder','loginwa-otp'), value: attributes.phone_placeholder, onChange: set('phone_placeholder') }),
                        el(TextControl, { label: __('OTP placeholder','loginwa-otp'), value: attributes.otp_placeholder, onChange: set('otp_placeholder') }),
                    ]),
                    el(PanelBody, { title: __('Layout & Appearance','loginwa-otp'), initialOpen:false }, [
                        el(SelectControl, { label: __('Theme','loginwa-otp'), value: attributes.theme_mode, options:[
                            { label:'Auto', value:'auto' },
                            { label:'Light', value:'light' },
                            { label:'Dark', value:'dark' },
                        ], onChange: set('theme_mode') }),
                        el(SelectControl, { label: __('Layout','loginwa-otp'), value: attributes.layout, options:[
                            { label:__('Split','loginwa-otp'), value:'split' },
                            { label:__('Stacked','loginwa-otp'), value:'stacked' },
                        ], onChange: set('layout') }),
                        el(SelectControl, { label: __('Hero alignment','loginwa-otp'), value: attributes.hero_align, options:[
                            { label:__('Left','loginwa-otp'), value:'left' },
                            { label:__('Center','loginwa-otp'), value:'center' },
                        ], onChange: set('hero_align') }),
                        el(RangeControl, { label: __('Card max width (px)','loginwa-otp'), value: attributes.card_max_width, onChange: set('card_max_width'), min:280, max:640 }),
                        el(RangeControl, { label: __('Card radius (px)','loginwa-otp'), value: attributes.border_radius, onChange: set('border_radius'), min:8, max:32 }),
                        el(RangeControl, { label: __('Layout gap (px)','loginwa-otp'), value: attributes.body_gap, onChange: set('body_gap'), min:12, max:60 }),
                        el(RangeControl, { label: __('Card padding (px)','loginwa-otp'), value: attributes.form_padding, onChange: set('form_padding'), min:12, max:36 }),
                        el(ToggleControl, { label: __('Enable shadow','loginwa-otp'), checked: attributes.shadow, onChange: set('shadow') }),
                        el(SelectControl, { label: __('Background type','loginwa-otp'), value: attributes.background_type, options:[
                            { label:__('Default','loginwa-otp'), value:'default' },
                            { label:__('Custom gradient','loginwa-otp'), value:'gradient' },
                            { label:__('Solid color','loginwa-otp'), value:'solid' },
                        ], onChange: set('background_type') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Accent color','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.accent_color, onChange: set('accent_color') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Background from','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.background_from, onChange: set('background_from') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Background to / solid','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.background_to, onChange: set('background_to') }),
                    ]),
                ]),
                el('div', {
                    className:'loginwa-otp loginwa-otp--preview' + (attributes.shadow ? '' : ' loginwa-otp--flat'),
                    'data-theme': attributes.theme_mode,
                    'data-layout': attributes.layout,
                    'data-align': attributes.hero_align,
                    style: Object.assign({ '--loginwa-radius': attributes.border_radius + 'px' }, inlineBg(attributes.background_type, attributes.background_from, attributes.background_to))
                }, [
                    el('div', { className:'loginwa-otp__body' }, [
                        attributes.show_hero ? el('div', { className:'loginwa-otp__hero' }, [
                            attributes.logo_url ? el('div', { className:'loginwa-otp__logo' }, el('img', { src: attributes.logo_url, alt: attributes.logo_alt || 'Logo' })) : null,
                            attributes.show_badge ? el('span', { className:'loginwa-otp__badge' }, attributes.badge || __('Passwordless access','loginwa-otp')) : null,
                            el('h2', {}, attributes.heading || __('LoginWA OTP Login','loginwa-otp')),
                            attributes.subheading ? el('div', { className:'loginwa-otp__sub' }, attributes.subheading) : null,
                            attributes.description ? el('div', { className:'loginwa-otp__desc' }, attributes.description) : null,
                        ]) : null,
                        el('form', { className:'loginwa-otp__form loginwa-otp__form--login loginwa-otp__form--compact', style:{ '--loginwa-accent': attributes.accent_color, maxWidth: attributes.card_max_width + 'px', padding: (attributes.form_padding || 22) + 'px' } }, [
                            attributes.show_country ? el('div', { className:'loginwa-otp__row' }, [
                                el('label', {}, __('Country code','loginwa-otp')),
                                el('input', { type:'text', placeholder:'+62', disabled:true })
                            ]) : null,
                            el('div', { className:'loginwa-otp__row' }, [
                                el('label', {}, __('Phone number','loginwa-otp')),
                                el('input', { type:'text', placeholder: attributes.phone_placeholder, disabled:true })
                            ]),
                            el('div', { className:'loginwa-otp__row loginwa-otp__row--inline' }, [
                                el('button', { type:'button', className:'loginwa-otp__send', disabled:true }, attributes.send_label || __('Send code','loginwa-otp')),
                                attributes.show_hint ? el('span', { className:'loginwa-otp__hint' }, attributes.hint || __('We will text a one-time code.','loginwa-otp')) : null
                            ]),
                            el('div', { className:'loginwa-otp__row loginwa-otp__otp-section' }, [
                                el('label', {}, __('OTP code','loginwa-otp')),
                                el('input', { type:'text', placeholder: attributes.otp_placeholder, disabled:true })
                            ]),
                            el('div', { className:'loginwa-otp__row loginwa-otp__otp-section' }, [
                                el('button', { type:'button', className:'loginwa-otp__verify loginwa-otp__verify--login', disabled:true }, attributes.verify_label || __('Login','loginwa-otp'))
                            ]),
                        ])
                    ])
                ])
            ]);
        },
        save: () => null,
    });

    // Drag-drop builder with InnerBlocks
    const builderTemplate = [
        ['loginwa/otp-hero', {}],
        ['loginwa/otp-form', {}],
    ];

    registerBlockType('loginwa/otp-builder', {
        title: __('LoginWA OTP Builder','loginwa-otp'),
        icon: 'layout',
        category: 'layout',
        attributes: {
            accent_color: { type:'string', default:'#22d3ee' },
            background_type: { type:'string', default:'default' },
            background_from: { type:'string', default:'#22d3ee' },
            background_to: { type:'string', default:'#6366f1' },
            card_max_width: { type:'number', default:420 },
            border_radius: { type:'number', default:18 },
            shadow: { type:'boolean', default:true },
            layout: { type:'string', default:'split' },
            hero_align: { type:'string', default:'center' },
            body_gap: { type:'number', default:28 },
            form_padding: { type:'number', default:22 },
            theme_mode: { type:'string', default:'auto' },
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const set = (k) => (v) => setAttributes({ [k]: v });
            return el('div', {
                className:'loginwa-otp loginwa-otp--preview' + (attributes.shadow ? '' : ' loginwa-otp--flat'),
                'data-theme': attributes.theme_mode,
                'data-layout': attributes.layout,
                'data-align': attributes.hero_align,
                style: Object.assign({ '--loginwa-radius': attributes.border_radius + 'px' }, inlineBg(attributes.background_type, attributes.background_from, attributes.background_to))
            }, [
                el(InspectorControls, {}, [
                    el(PanelBody, { title: __('Wrapper','loginwa-otp'), initialOpen:true }, [
                        el(SelectControl, { label: __('Theme','loginwa-otp'), value: attributes.theme_mode, options:[
                            { label:'Auto', value:'auto' },
                            { label:'Light', value:'light' },
                            { label:'Dark', value:'dark' },
                        ], onChange: set('theme_mode') }),
                        el(SelectControl, { label: __('Layout','loginwa-otp'), value: attributes.layout, options:[
                            { label:__('Split','loginwa-otp'), value:'split' },
                            { label:__('Stacked','loginwa-otp'), value:'stacked' },
                        ], onChange: set('layout') }),
                        el(SelectControl, { label: __('Hero alignment','loginwa-otp'), value: attributes.hero_align, options:[
                            { label:__('Left','loginwa-otp'), value:'left' },
                            { label:__('Center','loginwa-otp'), value:'center' },
                        ], onChange: set('hero_align') }),
                        el(RangeControl, { label: __('Layout gap (px)','loginwa-otp'), value: attributes.body_gap, onChange: set('body_gap'), min:12, max:60 }),
                        el(RangeControl, { label: __('Card padding (px)','loginwa-otp'), value: attributes.form_padding, onChange: set('form_padding'), min:12, max:36 }),
                        el(RangeControl, { label: __('Card max width (px)','loginwa-otp'), value: attributes.card_max_width, onChange: set('card_max_width'), min:280, max:640 }),
                        el(RangeControl, { label: __('Card radius (px)','loginwa-otp'), value: attributes.border_radius, onChange: set('border_radius'), min:8, max:32 }),
                        el(ToggleControl, { label: __('Enable shadow','loginwa-otp'), checked: attributes.shadow, onChange: set('shadow') }),
                        el(SelectControl, { label: __('Background type','loginwa-otp'), value: attributes.background_type, options:[
                            { label:__('Default','loginwa-otp'), value:'default' },
                            { label:__('Custom gradient','loginwa-otp'), value:'gradient' },
                            { label:__('Solid color','loginwa-otp'), value:'solid' },
                        ], onChange: set('background_type') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Accent color','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.accent_color, onChange: set('accent_color') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Background from','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.background_from, onChange: set('background_from') }),
                        el('div', { style:{ marginTop:'10px' } }, [ el('label', {}, __('Background to / solid','loginwa-otp')) ]),
                        el(ColorPalette, { colors: palette.map(c => ({ color:c })), value: attributes.background_to, onChange: set('background_to') }),
                    ]),
                ]),
                el('div', { className:'loginwa-otp__body', style:{ gap: (attributes.body_gap||28)+'px' } }, [
                    el(wp.blockEditor.InnerBlocks, {
                        allowedBlocks: ['loginwa/otp-hero','loginwa/otp-form'],
                        template: builderTemplate,
                        templateLock: false
                    })
                ])
            ]);
        },
        save: (props) => {
            const { attributes } = props;
            const classes = 'loginwa-otp' + (attributes.shadow ? '' : ' loginwa-otp--flat');
            return el('div', {
                className: classes,
                'data-theme': attributes.theme_mode,
                'data-layout': attributes.layout,
                'data-align': attributes.hero_align,
                style: Object.assign({
                    '--loginwa-radius': (attributes.border_radius||18) + 'px',
                    '--loginwa-accent': attributes.accent_color,
                    padding: (attributes.form_padding||22) + 'px'
                }, inlineBg(attributes.background_type, attributes.background_from, attributes.background_to))
            }, [
                el('div', { className:'loginwa-otp__body', style:{ gap: (attributes.body_gap||28)+'px' } }, [
                    el(wp.blockEditor.InnerBlocks.Content, null)
                ])
            ]);
        }
    });

    // Hero child block
    registerBlockType('loginwa/otp-hero', {
        title: __('LoginWA OTP Hero','loginwa-otp'),
        icon: 'admin-users',
        category: 'layout',
        parent: ['loginwa/otp-builder'],
        attributes: {
            heading: { type:'string', default:'LoginWA OTP Login' },
            subheading: { type:'string', default:'' },
            description: { type:'string', default:'' },
            badge: { type:'string', default:'Passwordless access' },
            show_badge: { type:'boolean', default:true },
            logo_url: { type:'string', default:'' },
            logo_alt: { type:'string', default:'LoginWA' },
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const set = (k) => (v) => setAttributes({ [k]: v });
            return el('div', { className:'loginwa-otp__hero' }, [
                attributes.logo_url ? el('div', { className:'loginwa-otp__logo' }, el('img', { src: attributes.logo_url, alt: attributes.logo_alt || 'Logo' })) : null,
                el(ToggleControl, { label: __('Show badge','loginwa-otp'), checked: attributes.show_badge, onChange: set('show_badge') }),
                attributes.show_badge ? el(TextControl, { label: __('Badge','loginwa-otp'), value: attributes.badge, onChange: set('badge') }) : null,
                el(TextControl, { label: __('Heading','loginwa-otp'), value: attributes.heading, onChange: set('heading') }),
                el(TextControl, { label: __('Subheading','loginwa-otp'), value: attributes.subheading, onChange: set('subheading') }),
                el(TextControl, { label: __('Description','loginwa-otp'), value: attributes.description, onChange: set('description') }),
                el(TextControl, { label: __('Logo URL','loginwa-otp'), value: attributes.logo_url, onChange: set('logo_url') }),
                el(TextControl, { label: __('Logo alt','loginwa-otp'), value: attributes.logo_alt, onChange: set('logo_alt') }),
            ]);
        },
        save: (props) => {
            const { attributes } = props;
            return el('div', { className:'loginwa-otp__hero' }, [
                attributes.logo_url ? el('div', { className:'loginwa-otp__logo' }, el('img', { src: attributes.logo_url, alt: attributes.logo_alt || 'Logo' })) : null,
                attributes.show_badge ? el('span', { className:'loginwa-otp__badge' }, attributes.badge || 'Passwordless access') : null,
                el('h2', {}, attributes.heading || 'LoginWA OTP Login'),
                attributes.subheading ? el('div', { className:'loginwa-otp__sub' }, attributes.subheading) : null,
                attributes.description ? el('div', { className:'loginwa-otp__desc' }, attributes.description) : null,
            ]);
        }
    });

    // Form child block
    registerBlockType('loginwa/otp-form', {
        title: __('LoginWA OTP Form','loginwa-otp'),
        icon: 'feedback',
        category: 'layout',
        parent: ['loginwa/otp-builder'],
        attributes: {
            show_country: { type:'boolean', default:true },
            show_hint: { type:'boolean', default:true },
            hint: { type:'string', default:'We will text a one-time code.' },
            send_label: { type:'string', default:'Send code' },
            verify_label: { type:'string', default:'Login' },
            phone_placeholder: { type:'string', default:'81234567890' },
            otp_placeholder: { type:'string', default:'123456' },
            preferred_countries: { type:'string', default:'' },
            show_flags: { type:'boolean', default:true },
        },
        edit: (props) => {
            const { attributes, setAttributes } = props;
            const set = (k) => (v) => setAttributes({ [k]: v });
            return el('div', { className:'loginwa-otp__form loginwa-otp__form--login loginwa-otp__form--compact is-editor' }, [
                el(ToggleControl, { label: __('Show country dropdown','loginwa-otp'), checked: attributes.show_country, onChange: set('show_country') }),
                el(ToggleControl, { label: __('Show flags','loginwa-otp'), checked: attributes.show_flags, onChange: set('show_flags') }),
                el(TextControl, { label: __('Preferred country codes (comma)','loginwa-otp'), value: attributes.preferred_countries, onChange: set('preferred_countries') }),
                el(TextControl, { label: __('Hint text','loginwa-otp'), value: attributes.hint, onChange: set('hint') }),
                el(TextControl, { label: __('Send button label','loginwa-otp'), value: attributes.send_label, onChange: set('send_label') }),
                el(TextControl, { label: __('Verify button label','loginwa-otp'), value: attributes.verify_label, onChange: set('verify_label') }),
                el(TextControl, { label: __('Phone placeholder','loginwa-otp'), value: attributes.phone_placeholder, onChange: set('phone_placeholder') }),
                el(TextControl, { label: __('OTP placeholder','loginwa-otp'), value: attributes.otp_placeholder, onChange: set('otp_placeholder') }),
            ]);
        },
        save: (props) => {
            const { attributes } = props;
            return el('form', {
                className:'loginwa-otp__form loginwa-otp__form--login loginwa-otp__form--compact',
                'data-hint-default': attributes.hint || 'We will text a one-time code.',
                'data-hint-success': 'Code sent.',
                'data-hint-sending': 'Sending...'
            }, [
                attributes.show_country ? el('div', { className:'loginwa-otp__row loginwa-otp__row--country', 'data-show-flags': attributes.show_flags ? '1' : '0', 'data-preferred': attributes.preferred_countries || '', 'data-default-country': '' }, [
                    el('label', {}, __('Country code','loginwa-otp')),
                    el('select', { name:'country_code', className:'loginwa-otp__country' })
                ]) : null,
                el('div', { className:'loginwa-otp__row' }, [
                    el('label', {}, __('Phone number','loginwa-otp')),
                    el('input', { type:'text', name:'phone', placeholder: attributes.phone_placeholder || '81234567890', required:true })
                ]),
                el('div', { className:'loginwa-otp__row loginwa-otp__row--inline' }, [
                    el('button', { type:'button', className:'loginwa-otp__send' }, attributes.send_label || 'Send code'),
                    attributes.show_hint ? el('span', { className:'loginwa-otp__hint' }, attributes.hint || 'We will text a one-time code.') : null
                ]),
                el('div', { className:'loginwa-otp__row loginwa-otp__otp-section' }, [
                    el('label', {}, __('OTP code','loginwa-otp')),
                    el('input', { type:'text', name:'otp_code', placeholder: attributes.otp_placeholder || '123456', inputMode:'numeric' })
                ]),
                el('div', { className:'loginwa-otp__row loginwa-otp__otp-section' }, [
                    el('button', { type:'button', className:'loginwa-otp__verify loginwa-otp__verify--login' }, attributes.verify_label || 'Login')
                ]),
                el('div', { className:'loginwa-otp__status', 'aria-live':'polite' })
            ]);
        }
    });
})();
